/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.samples;

import es.uvigo.ei.sing.s2p.core.entities.Sample;
import es.uvigo.ei.sing.s2p.core.operations.StringSetComparison;
import es.uvigo.ei.sing.s2p.gui.UISettings;
import es.uvigo.ei.sing.s2p.gui.components.VennDiagram;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SamplesComparisonInformationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Sample sample1;
    private Sample sample2;
    private StringSetComparison comparison;
    private JLabel informationLabel;
    private VennDiagram vennDiagram;

    public SamplesComparisonInformationPanel(Sample sample1, Sample sample2) {
        this.sample1 = sample1;
        this.sample2 = sample2;
        this.comparison = new StringSetComparison(sample1.getSpots(), sample2.getSpots());
        this.initComponent();
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.setBackground(UISettings.BG_COLOR);
        this.add((Component)this.getInformationLabel(), "North");
        this.add((Component)this.getVennDiagram(), "Center");
    }

    private JLabel getInformationLabel() {
        if (this.informationLabel == null) {
            this.informationLabel = new JLabel(this.getLabelText(), 0);
            this.informationLabel.setFont(this.informationLabel.getFont().deriveFont(0));
        }
        return this.informationLabel;
    }

    private String getLabelText() {
        StringBuilder sb = new StringBuilder();
        sb.append("Common proteins: ").append(this.comparison.getIntersectionSize()).append(" | ").append(this.sample1.getName()).append(" unique proteins: ").append(this.comparison.getSet1UniqueSize()).append(" | ").append(this.sample2.getName()).append(" unique proteins: ").append(this.comparison.getSet2UniqueSize());
        return sb.toString();
    }

    private VennDiagram getVennDiagram() {
        if (this.vennDiagram == null) {
            int max = Math.max(this.comparison.getSet1Size(), this.comparison.getSet2Size());
            this.vennDiagram = new VennDiagram(this.sample1.getName(), this.sample2.getName(), (double)this.comparison.getSet1Size() / (double)max, (double)this.comparison.getSet2Size() / (double)max, (double)this.comparison.getIntersectionSize() / (double)max);
        }
        return this.vennDiagram;
    }
}

