/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.math.statistical.corrections;

import es.uvigo.ei.sing.math.statistical.corrections.Correction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

public abstract class AbstractRankCorrection
implements Correction,
Serializable {
    private static final long serialVersionUID = 1L;

    protected abstract double correctPValue(double var1, int var3, int var4);

    protected void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    @Override
    public double[] correct(double[] pValues, boolean skipNaN) throws InterruptedException {
        this.checkInterrupted();
        double[] qValues = new double[pValues.length];
        Arrays.fill(qValues, Double.NaN);
        ArrayList<Test> tests = new ArrayList<Test>(pValues.length);
        int i = 0;
        while (i < pValues.length) {
            if (!skipNaN || !Double.isNaN(pValues[i])) {
                tests.add(new Test(i, pValues[i]));
            }
            ++i;
        }
        this.checkInterrupted();
        Collections.sort(tests, new Comparator<Test>(){

            @Override
            public int compare(Test o1, Test o2) {
                return Double.compare(o1.pValue, o2.pValue);
            }
        });
        this.checkInterrupted();
        Test previousTest = null;
        int i2 = tests.size() - 1;
        while (i2 >= 0) {
            Test test = (Test)tests.get(i2);
            double qValue = this.correctPValue(test.pValue, i2 + 1, tests.size());
            test.qValue = previousTest != null && !Double.isNaN(previousTest.qValue) ? Math.min(previousTest.qValue, qValue) : qValue;
            previousTest = test;
            this.checkInterrupted();
            --i2;
        }
        for (Test test : tests) {
            qValues[test.position] = test.qValue;
            this.checkInterrupted();
        }
        return qValues;
    }

    protected static class Test {
        protected int position;
        protected double pValue;
        protected double qValue;

        protected Test(int pos, double pval) {
            this.position = pos;
            this.pValue = pval;
        }

        public String toString() {
            return String.valueOf(Double.toString(this.pValue)) + "(" + this.position + ")";
        }
    }
}

