/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core.operation.execution;

import es.uvigo.ei.aibench.core.operation.execution.ResultsCollector;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

class OutcomeTransformer {
    private final boolean dataSource;
    private final int pos;
    private final ResultsCollector collector;

    OutcomeTransformer(boolean dataSource, ResultsCollector collector, int pos) {
        if (collector == null) {
            throw new NullPointerException("collector can't be null");
        }
        if (pos < 0) {
            throw new IllegalArgumentException("pos must be equal or greater than zero");
        }
        this.dataSource = dataSource;
        this.pos = pos;
        this.collector = collector;
    }

    void resultMade(Object result) {
        if (this.dataSource) {
            Collection<Object> results = this.extract(result);
            for (Object obj : results) {
                this.collector.newResult(this.pos, obj);
            }
        } else {
            this.collector.newResult(this.pos, result);
        }
    }

    void crash(Throwable e) {
        this.collector.crash(e);
    }

    private Collection<Object> extract(Object result) {
        if (result instanceof Iterable) {
            Iterable returnValue = (Iterable)result;
            return this.extract(returnValue.iterator());
        }
        if (result.getClass().isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            int length = Array.getLength(result);
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(result, i));
            }
            return list;
        }
        return this.extract((Iterator)result);
    }

    private Collection<Object> extract(Iterator<?> iter) {
        ArrayList<Object> result = new ArrayList<Object>();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }
}

