/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench;

import es.uvigo.ei.aibench.core.Core;
import es.uvigo.ei.aibench.workbench.Workbench;
import es.uvigo.ei.aibench.workbench.interfaces.AbstractViewFactory;
import es.uvigo.ei.aibench.workbench.utilities.Utilities;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.DefaultTableModel;

public class DefaultViewFactory
extends AbstractViewFactory
implements Observer {
    private JTextArea textarea = null;
    private JTable table = null;
    private JTable arrayTable = null;
    private Object data = null;

    public DefaultViewFactory() {
        this.name = "Default view";
    }

    @Override
    public JComponent getComponent(Object data) {
        this.data = data;
        if (Core.CONFIG.containsKey("clipboard.listenobservables") && Boolean.parseBoolean(Core.CONFIG.getProperty("clipboard.listenobservables")) && data instanceof Observable) {
            ((Observable)data).addObserver(this);
        }
        final JSplitPane componentExtensionIntance = this.getSplitter(data);
        if (Boolean.parseBoolean(Core.CONFIG.getProperty("help.enabled", "false"))) {
            final ComponentAdapter adapter = new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    Container container;
                    Frame parentFrame = Utilities.getParentFrame(componentExtensionIntance);
                    if (parentFrame instanceof JFrame && (container = ((JFrame)parentFrame).getContentPane()) instanceof JComponent) {
                        JComponent containerComponent = (JComponent)container;
                        containerComponent.putClientProperty("AIBench.help", null);
                    }
                }
            };
            componentExtensionIntance.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    for (ComponentListener listener : (ComponentListener[])event.getAncestor().getListeners(ComponentListener.class)) {
                        if (listener == adapter) break;
                    }
                    event.getAncestor().addComponentListener(adapter);
                    if (event.getAncestor().isVisible()) {
                        adapter.componentShown(null);
                    }
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                }
            });
        }
        return componentExtensionIntance;
    }

    public JSplitPane getSplitter(Object data) {
        JSplitPane splitter = new JSplitPane();
        splitter.setOrientation(0);
        if (data != null && (data instanceof Collection || data.getClass().isArray()) && Workbench.CONFIG.getProperty("defaultview.use_table_for_collections_and_arrays") != null && Workbench.CONFIG.getProperty("defaultview.use_table_for_collections_and_arrays").equals("true")) {
            splitter.setTopComponent(new JScrollPane(this.getCollectionTable()));
        } else {
            splitter.setTopComponent(new JScrollPane(this.getTextArea()));
        }
        splitter.setBottomComponent(new JScrollPane(this.getPropertyTable()));
        splitter.setResizeWeight(0.5);
        return splitter;
    }

    private JTable getCollectionTable() {
        if (this.arrayTable == null) {
            this.arrayTable = new JTable();
            this.arrayTable.setCellSelectionEnabled(true);
            DefaultTableModel model = (DefaultTableModel)this.arrayTable.getModel();
            model.setColumnIdentifiers(new Object[]{"index", "toString"});
            int maxContentSize = 0;
            if (this.data.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(this.data); ++i) {
                    String content = "null";
                    if (Array.get(this.data, i) != null) {
                        content = Array.get(this.data, i).toString();
                    }
                    maxContentSize = Math.max(maxContentSize, this.arrayTable.getFontMetrics(this.arrayTable.getFont()).stringWidth(content) + 5);
                    model.addRow(new Object[]{i, Array.get(this.data, i)});
                }
            } else {
                Collection c = (Collection)this.data;
                int counter = 0;
                for (Object elem : c) {
                    String content = "null";
                    if (elem != null) {
                        content = elem.toString();
                    }
                    maxContentSize = Math.max(maxContentSize, this.arrayTable.getFontMetrics(this.arrayTable.getFont()).stringWidth(content) + 5);
                    model.addRow(new Object[]{counter++, elem});
                }
            }
            this.arrayTable.setAutoResizeMode(0);
            int firstColumnSize = Math.max(this.arrayTable.getFontMetrics(this.arrayTable.getFont()).stringWidth("index") + 5, this.arrayTable.getFontMetrics(this.arrayTable.getFont()).stringWidth("" + model.getRowCount()) + 5);
            maxContentSize = Math.max(this.arrayTable.getFontMetrics(this.arrayTable.getFont()).stringWidth("toString") + 5, maxContentSize);
            this.arrayTable.getColumnModel().getColumn(0).setPreferredWidth(firstColumnSize);
            this.arrayTable.getColumnModel().getColumn(1).setPreferredWidth(maxContentSize);
        }
        return this.arrayTable;
    }

    public JTextArea getTextArea() {
        if (this.textarea == null) {
            String text = this.data == null ? "<NULL>" : this.data.toString();
            this.textarea = new JTextArea(text);
            this.textarea.setEditable(false);
            Font defaultFont = this.textarea.getFont();
            this.textarea.setFont(new Font("Courier", defaultFont.getStyle(), defaultFont.getSize()));
        }
        return this.textarea;
    }

    private void updateTable() {
        while (((DefaultTableModel)this.table.getModel()).getRowCount() > 0) {
            ((DefaultTableModel)this.table.getModel()).removeRow(0);
        }
        ((DefaultTableModel)this.table.getModel()).setColumnCount(2);
        ((DefaultTableModel)this.table.getModel()).setColumnIdentifiers(new Object[]{"property", "value"});
        if (this.data == null) {
            return;
        }
        try {
            BeanInfo info = Introspector.getBeanInfo(this.data.getClass());
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            if (descriptors != null) {
                for (PropertyDescriptor descriptor : descriptors) {
                    Method read = descriptor.getReadMethod();
                    if (read == null) continue;
                    try {
                        Object readed = read.invoke(this.data, new Object[0]);
                        ((DefaultTableModel)this.table.getModel()).addRow(new Object[]{descriptor.getName(), readed});
                    }
                    catch (Exception e) {
                        ((DefaultTableModel)this.table.getModel()).addRow(new Object[]{descriptor.getName(), "<the method reported an " + e.getClass().getSimpleName() + " exception>"});
                    }
                }
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public JTable getPropertyTable() {
        if (this.table == null) {
            this.table = new JTable();
            this.table.setEnabled(false);
            this.updateTable();
        }
        return this.table;
    }

    @Override
    public void update(Observable o, Object arg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultViewFactory.this.getTextArea().setText(DefaultViewFactory.this.data.toString());
                DefaultViewFactory.this.updateTable();
            }
        });
    }

    @Override
    public Class<?> getComponentClass() {
        return JComponent.class;
    }
}

