/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.math.statistical.tests;

import es.uvigo.ei.sing.math.ArrayUtils;
import es.uvigo.ei.sing.math.statistical.UnsupportedMatrixException;
import es.uvigo.ei.sing.math.statistical.tests.AbstractTestOfIndependence;
import es.uvigo.ei.sing.math.statistical.tests.TestOfIndependence;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;

public class YatesChiSquareTestOfIndependence
extends AbstractTestOfIndependence
implements TestOfIndependence {
    private static final long serialVersionUID = 1L;

    @Override
    public double test(int[][] matrix) throws UnsupportedMatrixException {
        if (!ArrayUtils.checkSquareMatrixDimensions(matrix, 2)) {
            throw new UnsupportedMatrixException("Fisher Test is valid only for 2x2 matrices");
        }
        ChiSquaredDistribution chi2 = new ChiSquaredDistribution(1.0);
        return 1.0 - chi2.cumulativeProbability(YatesChiSquareTestOfIndependence.yatesChiSquare(matrix));
    }

    private static final double yatesChiSquare(int[][] counts) {
        if (counts.length != 2 || counts[0].length != 2 || counts[1].length != 2) {
            throw new IllegalArgumentException("Matrix must be 2x2");
        }
        double a = counts[0][0];
        double b = counts[1][0];
        double c = counts[0][1];
        double d = counts[1][1];
        double Na = a + b;
        double Nb = c + d;
        double Ns = a + c;
        double Nf = b + d;
        double N = a + b + c + d;
        return N * Math.pow(Math.max(0.0, Math.abs(a * d - b * c) - N / 2.0), 2.0) / (Ns * Nf * Na * Nb);
    }
}

