/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.core.io;

import es.uvigo.ei.sing.commons.csv.entities.CsvData;
import es.uvigo.ei.sing.commons.csv.entities.CsvEntry;
import es.uvigo.ei.sing.commons.csv.entities.CsvFormat;
import es.uvigo.ei.sing.commons.csv.io.CsvReader;
import es.uvigo.ei.sing.s2p.core.entities.MascotEntry;
import es.uvigo.ei.sing.s2p.core.entities.MascotIdentifications;
import es.uvigo.ei.sing.s2p.core.operations.MascotIdentificationsOperations;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;

public class MascotCsvLoader {
    public static MascotIdentifications load(File file, CsvFormat csvFormat, int minScore, boolean removeDuplicates) throws IOException {
        MascotIdentifications entries = MascotIdentificationsOperations.filter(MascotCsvLoader.load(file, csvFormat), minScore);
        return removeDuplicates ? MascotIdentificationsOperations.removeDuplicates(entries) : entries;
    }

    public static MascotIdentifications load(File file, CsvFormat csvFormat) throws IOException {
        CsvData data = CsvReader.CsvReaderBuilder.newCsvReaderBuilder().withFormat(csvFormat).withHeader().build().read(file);
        return MascotCsvLoader.parseEntries(data);
    }

    private static MascotIdentifications parseEntries(CsvData data) throws IOException {
        MascotIdentifications entries = new MascotIdentifications();
        for (CsvEntry e : data) {
            entries.add(MascotCsvLoader.parseEntry(e, data.getFormat()));
        }
        return entries;
    }

    private static MascotEntry parseEntry(CsvEntry entry, CsvFormat format) throws IOException {
        String title = (String)entry.get(0);
        String platePosition = (String)entry.get(1);
        int mascotScore = MascotCsvLoader.asInt((String)entry.get(2));
        int difference = MascotCsvLoader.asInt((String)entry.get(3));
        int msCoverage = MascotCsvLoader.asInt((String)entry.get(4));
        double proteinMW = MascotCsvLoader.asDouble((String)entry.get(5), format);
        String method = (String)entry.get(6);
        double pIValue = MascotCsvLoader.asDouble((String)entry.get(7), format);
        String accession = (String)entry.get(8);
        return new MascotEntry(title, platePosition, mascotScore, difference, msCoverage, proteinMW, method, pIValue, accession);
    }

    private static double asDouble(String string, CsvFormat format) throws IOException {
        try {
            return format.getDecimalFormatter().parse(string).doubleValue();
        }
        catch (ParseException e) {
            throw new IOException("Can't parse number " + string, e);
        }
    }

    private static int asInt(String string) throws IOException {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException e) {
            throw new IOException("Can't parse number " + string, e);
        }
    }
}

