/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.openmbean;

import com.oracle.jrockit.jfr.InvalidEventDefinitionException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.SimpleType;
import oracle.jrockit.jfr.events.EventDescriptor;
import oracle.jrockit.jfr.events.JavaEventDescriptor;
import oracle.jrockit.jfr.events.ValueDescriptor;
import oracle.jrockit.jfr.openmbean.EventSettingType;
import oracle.jrockit.jfr.openmbean.LazyImmutableJFRMBeanType;
import oracle.jrockit.jfr.openmbean.Member;

@Deprecated
public final class EventDescriptorType
extends LazyImmutableJFRMBeanType<EventDescriptor> {
    static final Member<String> NAME = new Member("name", "Event name", SimpleType.STRING);
    static final Member<String> DESC = new Member("description", "Description", SimpleType.STRING);
    static final Member<String> PATH = new Member("path", "Event URI path", SimpleType.STRING);
    static final Member<String> EVENTURI = new Member("uri", "Event URI", SimpleType.STRING);
    static final Member<Boolean> HASSTARTTIME = new Member("hasStartTime", "Does event have a starttime (describes a period of time)", SimpleType.BOOLEAN);
    static final Member<Boolean> HASTHREAD = new Member("hasThread", "Does event contain a generating thread", SimpleType.BOOLEAN);
    static final Member<Boolean> HASSTACKTRACE = new Member("isStackTraceAvailable", "Can stacktrace be recorded for event", SimpleType.BOOLEAN);
    static final Member<Boolean> TIMED = new Member("isTimed", "Is event timed (responds to threshold)", SimpleType.BOOLEAN);
    static final Member<Boolean> REQUESTABLE = new Member("isRequestable", "Can event be requested/generated periodically", SimpleType.BOOLEAN);

    public EventDescriptorType() throws OpenDataException {
        super(EventDescriptor.class, "EventDescriptor", "Event descriptor", EventSettingType.ID, NAME, DESC, PATH, EVENTURI, HASSTARTTIME, HASTHREAD, HASSTACKTRACE, TIMED, REQUESTABLE);
    }

    @Override
    public EventDescriptor toJavaTypeDataLazy(CompositeData compositeData) throws OpenDataException {
        try {
            return new JavaEventDescriptor(this.intAt(compositeData, EventSettingType.ID), this.stringAt(compositeData, NAME), this.stringAt(compositeData, DESC), this.stringAt(compositeData, PATH), new URI(this.stringAt(compositeData, EVENTURI)), this.booleanAt(compositeData, HASSTARTTIME), this.booleanAt(compositeData, HASTHREAD), this.booleanAt(compositeData, HASSTACKTRACE), this.booleanAt(compositeData, TIMED), this.booleanAt(compositeData, REQUESTABLE), new ValueDescriptor[0]);
        }
        catch (InvalidEventDefinitionException | URISyntaxException exception) {
            throw new OpenDataException(exception.getMessage());
        }
    }

    @Override
    public CompositeData toCompositeTypeDataLazy(EventDescriptor eventDescriptor) throws OpenDataException {
        return new CompositeDataSupport(this.getType(), this.getNames(), new Object[]{eventDescriptor.getId(), eventDescriptor.getName(), eventDescriptor.getDescription(), eventDescriptor.getPath(), eventDescriptor.getURI().toString(), eventDescriptor.hasStartTime(), eventDescriptor.hasThread(), eventDescriptor.hasStackTrace(), eventDescriptor.isTimed(), eventDescriptor.isRequestable()});
    }
}

