/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.pipespecification.storage;

import es.uvigo.ei.aibench.core.operation.execution.CollectorAdapterFactory;
import es.uvigo.ei.aibench.core.operation.execution.Executable;
import es.uvigo.ei.aibench.core.operation.execution.IncompatibleConstraintsException;
import es.uvigo.ei.aibench.core.operation.execution.SerialExecutable;
import es.uvigo.ei.pipespecification.storage.PipeDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CompositedPipeDefinition
extends PipeDefinition {
    private final List<PipeDefinition> sons;
    private final Map<String, Class<?>> argumentsSpecification;
    private int totalLength = -1;

    static Map<String, Class<?>> aggregateArgumentsSpecification(PipeDefinition pipe1, PipeDefinition pipe2) {
        Map<String, Class<?>> map1 = pipe1.getArgumentsSpecification();
        return CompositedPipeDefinition.aggregateArgumentsSpecification(map1, pipe2);
    }

    static Map<String, Class<?>> aggregateArgumentsSpecification(Map<String, Class<?>> map1, PipeDefinition pipe2) {
        HashMap result = new HashMap(map1);
        Map<String, Class<?>> map2 = pipe2.getArgumentsSpecification();
        for (String key : map2.keySet()) {
            if (result.containsKey(key) && !((Class)result.get(key)).equals(map2.get(key))) {
                throw new RuntimeException("There is a name clashing for " + key + ". There are two different classes " + result.get(key) + ", " + map2.get(key));
            }
            result.put(key, map2.get(key));
        }
        return result;
    }

    CompositedPipeDefinition(PipeDefinition pipe1, PipeDefinition pipe2) throws IncompatibleConstraintsException {
        this(CompositedPipeDefinition.aggregateArgumentsSpecification(pipe1, pipe2), CompositedPipeDefinition.join(pipe1, pipe2));
    }

    private static List<PipeDefinition> join(PipeDefinition pipe1, PipeDefinition pipe2) throws IncompatibleConstraintsException {
        CollectorAdapterFactory.join(pipe1, pipe2);
        return Arrays.asList(pipe1, pipe2);
    }

    private CompositedPipeDefinition(Map<String, Class<?>> argumentsSpecification, List<PipeDefinition> sons) {
        super(sons.get(0).getIncomeTypes(), sons.get(sons.size() - 1).getOutcomeTypes());
        if (argumentsSpecification == null) {
            throw new IllegalArgumentException("the arguments specificacion can't be null");
        }
        if (sons.size() < 2) {
            throw new IllegalArgumentException("at least two pipeDefinitions");
        }
        this.argumentsSpecification = new HashMap(argumentsSpecification);
        this.sons = new ArrayList<PipeDefinition>(sons);
        this.invariant();
    }

    private void invariant() {
        assert (this.atLeastTwoSons()) : "there must be at least two sons";
    }

    private boolean atLeastTwoSons() {
        return this.sons.size() > 1;
    }

    @Override
    protected Executable instantiate_(Map<String, Object> args) {
        for (Map.Entry<String, Object> entry : args.entrySet()) {
            if (!this.argumentsSpecification.containsKey(entry.getKey())) {
                throw new IllegalArgumentException("the argument " + (String)entry.getKey() + " doesn't exist");
            }
            Class<?> klass = this.argumentsSpecification.get(entry.getKey());
            if (klass.isAssignableFrom(entry.getValue().getClass())) continue;
            throw new IllegalArgumentException("the object for the argument " + (String)entry.getKey() + " of class " + entry.getClass() + " cannot be assigned to " + klass);
        }
        ArrayList<Executable> pipes = new ArrayList<Executable>();
        for (PipeDefinition pipeDefinition : this.sons) {
            pipes.add(pipeDefinition.instantiate(args));
        }
        try {
            Map.Entry<String, Object> entry;
            entry = new SerialExecutable(pipes);
            return entry;
        }
        catch (Exception e) {
            throw new RuntimeException("The compatibility must had been checked");
        }
        finally {
            this.invariant();
        }
    }

    @Override
    public PipeDefinition join(PipeDefinition rightPart) throws IncompatibleConstraintsException {
        CollectorAdapterFactory.join(this, rightPart);
        ArrayList<PipeDefinition> newSons = new ArrayList<PipeDefinition>(this.sons);
        newSons.add(rightPart);
        return new CompositedPipeDefinition(CompositedPipeDefinition.aggregateArgumentsSpecification(this, rightPart), newSons);
    }

    @Override
    public Map<String, Class<?>> getArgumentsSpecification() {
        return this.argumentsSpecification;
    }

    @Override
    public int length() {
        return this.sons.size();
    }

    @Override
    public int totalLength() {
        if (this.totalLength == -1) {
            this.totalLength = 0;
            for (PipeDefinition def : this.sons) {
                this.totalLength += def.totalLength();
            }
        }
        return this.totalLength;
    }
}

