/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.core.io.samespots;

import es.uvigo.ei.sing.commons.csv.entities.CsvData;
import es.uvigo.ei.sing.commons.csv.entities.CsvEntry;
import es.uvigo.ei.sing.commons.csv.entities.CsvFormat;
import es.uvigo.ei.sing.commons.csv.io.CsvReader;
import es.uvigo.ei.sing.s2p.core.entities.Pair;
import es.uvigo.ei.sing.s2p.core.entities.Range;
import es.uvigo.ei.sing.s2p.core.entities.SameSpotsThrehold;
import es.uvigo.ei.sing.s2p.core.entities.Sample;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class SameSpotsCsvFileLoader {
    public static final SameSpotsThrehold DEFAULT_CSV_THRESHOLD = new SameSpotsThrehold(1.0, 0.0);
    private static final int INDEX_SPOT = 0;
    private static final int INDEX_P = 1;
    private static final int INDEX_FOLD = 2;

    public static Pair<Sample, Sample> load(File file, SameSpotsThrehold threshold, CsvFormat csvFormat) throws IOException {
        CsvData data = CsvReader.CsvReaderBuilder.newCsvReaderBuilder().withFormat(csvFormat).withHeader(false).build().read(file);
        return SameSpotsCsvFileLoader.parseSamples(data, threshold);
    }

    private static Pair<Sample, Sample> parseSamples(CsvData data, SameSpotsThrehold threshold) throws IOException {
        List<Integer> normalizedValuesColumns = SameSpotsCsvFileLoader.extractNormalizedColumns((CsvEntry)data.remove(0));
        Pair<Sample, Sample> samples = SameSpotsCsvFileLoader.extractSamples(data, threshold, normalizedValuesColumns);
        return samples;
    }

    private static List<Integer> extractNormalizedColumns(CsvEntry entry) {
        return IntStream.range(entry.indexOf((Object)"Normalized Volume"), entry.indexOf((Object)"Volume")).boxed().collect(Collectors.toList());
    }

    private static Pair<Sample, Sample> extractSamples(CsvData data, SameSpotsThrehold threshold, List<Integer> normalizedValuesColumns) throws IOException {
        CsvEntry sampleNamesEntry = (CsvEntry)data.remove(0);
        Pair<String, String> sampleNames = SameSpotsCsvFileLoader.extractSampleNames(sampleNamesEntry, normalizedValuesColumns);
        Pair<Range, Range> sampleColumns = SameSpotsCsvFileLoader.sampleColumns(sampleNamesEntry, sampleNames, normalizedValuesColumns);
        Pair<Map<String, Double>, Map<String, Double>> sampleValues = SameSpotsCsvFileLoader.extractSampleValues(data, threshold, sampleColumns, normalizedValuesColumns);
        return new Pair<Sample, Sample>(new Sample(sampleNames.getFirst(), sampleValues.getFirst()), new Sample(sampleNames.getSecond(), sampleValues.getSecond()));
    }

    private static Pair<Range, Range> sampleColumns(CsvEntry sampleNamesEntry, Pair<String, String> sampleNames, List<Integer> normalizedValuesColumns) {
        int firstSampleEnd;
        int firstSampleStart = sampleNamesEntry.indexOf((Object)sampleNames.getFirst());
        int secondSampleStart = firstSampleEnd = sampleNamesEntry.indexOf((Object)sampleNames.getSecond());
        int secondSampleEnd = normalizedValuesColumns.get(normalizedValuesColumns.size() - 1);
        return new Pair<Range, Range>(new Range(firstSampleStart, firstSampleEnd), new Range(secondSampleStart, secondSampleEnd));
    }

    private static Pair<String, String> extractSampleNames(CsvEntry entry, List<Integer> samplesColumns) {
        List sampleNames = samplesColumns.stream().map(arg_0 -> entry.get(arg_0)).distinct().filter(s -> s.length() > 0).collect(Collectors.toList());
        return new Pair<String, String>((String)sampleNames.get(0), (String)sampleNames.get(1));
    }

    private static Pair<Map<String, Double>, Map<String, Double>> extractSampleValues(CsvData data, SameSpotsThrehold threshold, Pair<Range, Range> sampleColumns, List<Integer> normalizedValuesColumns) throws IOException {
        data.remove(0);
        HashMap<String, Double> sample1 = new HashMap<String, Double>();
        HashMap<String, Double> sample2 = new HashMap<String, Double>();
        DecimalFormat formater = data.getFormat().getDecimalFormatter();
        try {
            for (CsvEntry e : data) {
                String spot = (String)e.get(0);
                double p = formater.parse((String)e.get(1)).doubleValue();
                double fold = formater.parse((String)e.get(2)).doubleValue();
                double s1 = SameSpotsCsvFileLoader.averageSampleValue(sampleColumns.getFirst(), formater, e);
                double s2 = SameSpotsCsvFileLoader.averageSampleValue(sampleColumns.getSecond(), formater, e);
                if (!(p <= threshold.getP()) || !(fold >= threshold.getFold())) continue;
                sample1.put(spot, s1);
                sample2.put(spot, s2);
            }
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        return new Pair<Map<String, Double>, Map<String, Double>>(sample1, sample2);
    }

    private static double averageSampleValue(Range sampleColumns, DecimalFormat formater, CsvEntry e) throws ParseException {
        List sample1Fields = e.subList(sampleColumns.getStart().intValue(), sampleColumns.getEnd().intValue());
        DescriptiveStatistics sample1Values = new DescriptiveStatistics();
        for (String s : sample1Fields) {
            sample1Values.addValue(formater.parse(s).doubleValue());
        }
        return sample1Values.getMean();
    }
}

