/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.core.io;

import es.uvigo.ei.sing.s2p.core.entities.MascotEntry;
import es.uvigo.ei.sing.s2p.core.entities.MascotIdentifications;
import es.uvigo.ei.sing.s2p.core.operations.MascotIdentificationsOperations;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class MascotProjectLoader {
    private static final String TITLE_DELIMITER = " OS";
    private static final int INDEX_TITLE = 0;
    private static final int INDEX_POS_ON_SCOUT = 4;
    private static final int INDEX_MASCOT_SCORE = 5;
    private static final int INDEX_DIFFERENCE = 6;
    private static final int INDEX_MS_COVERAGE = 7;
    private static final int INDEX_PROTEIN_MW = 8;
    private static final int INDEX_METHOD = 10;
    private static final int INDEX_PI_VALUE = 11;
    private static final int INDEX_ACCESSION = 13;

    public static MascotIdentifications load(File file) throws IOException {
        return MascotProjectLoader.load(file, false);
    }

    public static MascotIdentifications load(File file, boolean removeDuplicates) throws IOException {
        return MascotProjectLoader.load(file, Integer.MIN_VALUE, removeDuplicates);
    }

    public static MascotIdentifications load(File file, int minScore, boolean removeDuplicates) throws IOException {
        MascotIdentifications toret = new MascotIdentifications();
        HashMap<Integer, String> lastColumnValues = new HashMap<Integer, String>();
        Document doc = Jsoup.parse((File)file, (String)"UTF-8");
        Elements trs = doc.select("tr");
        for (Element tr : trs.subList(2, trs.size())) {
            Elements tds = tr.select("td");
            MascotEntry entry = MascotProjectLoader.createMascotEntry(tds, toret, lastColumnValues);
            if (entry.getMascotScore() <= minScore) continue;
            toret.add(entry);
        }
        return removeDuplicates ? MascotIdentificationsOperations.removeDuplicates(toret) : toret;
    }

    private static MascotEntry createMascotEntry(Elements tds, MascotIdentifications toret, Map<Integer, String> lastColumnValues) {
        return new MascotEntry(MascotProjectLoader.columnValue(0, tds, lastColumnValues), MascotProjectLoader.columnValue(4, tds, lastColumnValues), Integer.valueOf(MascotProjectLoader.columnValue(5, tds, lastColumnValues)), Integer.valueOf(MascotProjectLoader.columnValue(6, tds, lastColumnValues)), Integer.valueOf(MascotProjectLoader.columnValue(7, tds, lastColumnValues)), Double.valueOf(MascotProjectLoader.columnValue(8, tds, lastColumnValues)), MascotProjectLoader.columnValue(10, tds, lastColumnValues), Double.valueOf(MascotProjectLoader.columnValue(11, tds, lastColumnValues)), MascotProjectLoader.columnValue(13, tds, lastColumnValues));
    }

    private static String columnValue(int column, Elements tds, Map<Integer, String> lastColumnValues) {
        String text = ((Element)tds.get(column)).html();
        if (text.equals("&nbsp;")) {
            text = lastColumnValues.get(column);
        }
        if (column == 0 && text.contains(TITLE_DELIMITER)) {
            text = text.substring(0, text.indexOf(TITLE_DELIMITER));
        }
        lastColumnValues.put(column, text);
        return text;
    }
}

