/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.prefabvalues.factories;

import java.util.Comparator;
import java.util.LinkedHashSet;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.Tuple;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.AbstractReflectiveGenericFactory;
import nl.jqno.equalsverifier.internal.reflection.ConditionalInstantiator;
import nl.jqno.equalsverifier.internal.reflection.Util;

public abstract class ReflectiveGuavaTableFactory<T>
extends AbstractReflectiveGenericFactory<T> {
    private final String typeName;

    ReflectiveGuavaTableFactory(String typeName) {
        this.typeName = typeName;
    }

    public static <T> ReflectiveGuavaTableFactory<T> callFactoryMethod(final String typeName, final String methodName) {
        return new ReflectiveGuavaTableFactory<T>(typeName){

            @Override
            protected Object createEmpty() {
                return new ConditionalInstantiator(typeName).callFactory(methodName, Util.classes(new Class[0]), Util.objects(new Object[0]));
            }
        };
    }

    public static <T> ReflectiveGuavaTableFactory<T> callFactoryMethodWithComparator(final String typeName, final String methodName, final Object parameterValue) {
        return new ReflectiveGuavaTableFactory<T>(typeName){

            @Override
            protected Object createEmpty() {
                return new ConditionalInstantiator(typeName).callFactory(methodName, Util.classes(Comparator.class, Comparator.class), Util.objects(parameterValue, parameterValue));
            }
        };
    }

    protected abstract Object createEmpty();

    @Override
    public Tuple<T> createValues(TypeTag tag, PrefabValues prefabValues, LinkedHashSet<TypeTag> typeStack) {
        LinkedHashSet<TypeTag> clone = this.cloneWith(typeStack, tag);
        TypeTag columnTag = this.determineAndCacheActualTypeTag(0, tag, prefabValues, clone);
        TypeTag rowTag = this.determineAndCacheActualTypeTag(1, tag, prefabValues, clone);
        TypeTag valueTag = this.determineAndCacheActualTypeTag(2, tag, prefabValues, clone);
        Object red = this.createWith(prefabValues.giveRed(columnTag), prefabValues.giveRed(rowTag), prefabValues.giveBlack(valueTag));
        Object black = this.createWith(prefabValues.giveBlack(columnTag), prefabValues.giveBlack(rowTag), prefabValues.giveBlack(valueTag));
        Object redCopy = this.createWith(prefabValues.giveRed(columnTag), prefabValues.giveRed(rowTag), prefabValues.giveBlack(valueTag));
        return Tuple.of(red, black, redCopy);
    }

    private Object createWith(Object column, Object row, Object value) {
        Class<?> type = Util.classForName(this.typeName);
        Object result = this.createEmpty();
        this.invoke(type, result, "put", Util.classes(Object.class, Object.class, Object.class), Util.objects(column, row, value));
        return result;
    }
}

