package es.uvigo.esei.xcs.rest;

import javax.ejb.EJB;
import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import es.uvigo.esei.xcs.service.AdministratorService;
import es.uvigo.esei.xcs.service.EmailService;

/**
 * REST resource for administrator operations.
 * 
 * Provides endpoints for listing users and sending test emails.
 * Accessible under the path "/admin".
 * 
 * @author Breixo
 */
@Path("admin")
@Consumes(MediaType.APPLICATION_JSON)
@Produces(MediaType.APPLICATION_JSON)
public class AdministratorResource {

	@EJB
	private AdministratorService service;
	
	@EJB
	private EmailService emailService;

	/**
	 * Returns a paginated list of users managed by the administrator.
	 * 
	 * @param page index of the page (0-based)
	 * @param pageSize number of users per page
	 * @return HTTP 200 with the list of users
	 */
	@GET
	public Response list(@QueryParam("page") int page, @QueryParam("pageSize") int pageSize) {
		return Response.ok(this.service.list(page, pageSize)).build();
	}

	/**
	 * Sends a test email for verification purposes.
	 * 
	 * @return HTTP 200 if the email was sent successfully
	 */
	@POST
	public Response sendEmail() {
		this.emailService.send("email@fake.email", "Topic", "Text Message");
		return Response.ok().build();
	}
}
