# Incidencia sobre acceso de usuarios OWNER a vacunas

Actualmente, los usuarios de tipo `OWNER` deberían poder acceder a las vacunas de una mascota que poseen mediante la siguiente URL:

```

[http://localhost:8080/xcs-sample/rest/api/owner/pet/{petIdentifierType}/{petIdentifierValue}/vaccination](http://localhost:8080/xcs-sample/rest/api/owner/pet/{petIdentifierType}/{petIdentifierValue}/vaccination)

```

He intentado permitir este acceso modificando el archivo `web.xml` en:

```

/rest/target/rest-0.0.1-SNAPSHOT/WEB-INF/web.xml

````

con el siguiente bloque:

```xml
<security-constraint>
    <web-resource-collection>
        <web-resource-name>admin</web-resource-name>
        <url-pattern>/api/owner/*</url-pattern>
        <http-method-omission>OPTIONS</http-method-omission>
    </web-resource-collection>
    <auth-constraint>
        <role-name>ADMIN</role-name>
        <role-name>OWNER</role-name> <!-- añadido -->
    </auth-constraint>
</security-constraint>
````

No obstante, al ejecutar:

```
mvn clean install
```

el archivo `web.xml` se sobrescribe automáticamente, eliminando los cambios realizados. Esto impide que los usuarios de tipo `OWNER` accedan a la funcionalidad mencionada.
