package es.uvigo.esei.xcs.domain.entities;

import static java.util.Objects.requireNonNull;
import java.io.Serializable;
import java.util.Date;


import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.xml.bind.annotation.XmlTransient;

import com.fasterxml.jackson.annotation.JsonIgnore;

@Entity
public class Vaccination implements Serializable {
	private static final long serialVersionUID = 1L;

	public Vaccination() {}
	
	public Vaccination(Pet pet, Vaccine vaccine, Date date) {
		this.pet = pet;
		this.vaccine = vaccine;
		this.date = date;
	}
	
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY) //AUTO no genera auto_increment en MySQL
	private Long id;
	
	@Temporal(TemporalType.DATE)
	private Date date;
	
	@ManyToOne(fetch = FetchType.LAZY)
	@JsonIgnore
	private Pet pet;
	
	@ManyToOne(fetch = FetchType.EAGER)
	private Vaccine vaccine;
	
	public Long getId() {
		return this.id;
	}
	
	public Date getDate() {
		return this.date;
	}
	
	public void setDate(Date date) {
		requireNonNull(date);
		
		this.date = date;
	}
	
	public Pet getPet() {
		return this.pet;
	}
	
	public void setPet(Pet pet) {
		if (this.pet != null) {
			this.pet.internalRemoveVaccination(this);
		}
		this.pet = pet;
		if (pet != null) {
			pet.internalAddVaccination(this);
		}
	}
	
	public Vaccine getVaccine() {
		return this.vaccine;
	}
	
	public void setVaccine(Vaccine vaccine) {
		this.vaccine = vaccine;
	}
	
}
