package es.uvigo.esei.xcs.service;



import java.util.List;

import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import es.uvigo.esei.xcs.domain.entities.MonodoseVaccine;
import es.uvigo.esei.xcs.domain.entities.MultidoseVaccine;
import es.uvigo.esei.xcs.domain.entities.PeriodicType;
import es.uvigo.esei.xcs.domain.entities.PeriodicVaccine;
import es.uvigo.esei.xcs.domain.entities.Pet;
import es.uvigo.esei.xcs.domain.entities.Vaccine;

@Stateless
@PermitAll
//@RolesAllowed("VET")
public class VaccineService {
	@PersistenceContext
	private EntityManager em;
	
	public Vaccine get(Long id) {
		final Vaccine vaccine = em.find(Vaccine.class, id);
		
		return vaccine;
	}
	
	
	public List<Vaccine> list(int page, int pageSize){
		if (page < 0) {
			throw new IllegalArgumentException("The page can't be negative");
		}
		if (pageSize <= 0) {
			throw new IllegalArgumentException("The page size can't be negative or zero");
		}
		return em.createQuery("SELECT v FROM Vaccine v", Vaccine.class)
				.setFirstResult(page * pageSize)
				.setMaxResults(pageSize)
				.getResultList();
	}

	
	public Vaccine create(String name, String type, Integer doses, String periodicTypeString, Integer periode) {
		switch(type) {
	        case "MONODOSE": 
	        	MonodoseVaccine monodoseVaccine = new MonodoseVaccine(name); 
	        	em.persist(monodoseVaccine);
	    	    return monodoseVaccine;
	        case "MULTIDOSE": 
	        	MultidoseVaccine multidoseVaccine = new MultidoseVaccine(name, doses); 
	        	em.persist(multidoseVaccine);
	    	    return multidoseVaccine;
	        case "PERIODIC": 
	        	PeriodicType periodicType = null;
	            if (periodicTypeString != null) {
	                periodicType = PeriodicType.valueOf(periodicTypeString);
	            }
	        	PeriodicVaccine periodicVaccine = new PeriodicVaccine(name, periodicType, periode); 
	        	em.persist(periodicVaccine);
	    	    return periodicVaccine;
	        default: throw new IllegalArgumentException("Tipo de vacuna desconocido");
	    }
	    
	}

	
	public Vaccine update(Vaccine vaccine) {
		if (vaccine == null)
			throw new IllegalArgumentException("vaccine can't be null");
		
		return em.merge(vaccine);
	}
	
	
	public void remove(Long id) {
		final Vaccine vaccine = this.get(id);
		em.remove(vaccine);
	}
	
	
	public List<Pet> getVaccinatedPetsByVaccine(int vaccineId, int page, int pageSize){
		if (page < 0) {
			throw new IllegalArgumentException("The page can't be negative");
		}
		if (pageSize <= 0) {
			throw new IllegalArgumentException("The page size can't be negative or zero");
		}
		return em.createQuery("SELECT v.pet FROM Vaccination v "
				+ "WHERE v.vaccine.id = :vaccineId", Pet.class)
				.setFirstResult(page * pageSize)
				.setMaxResults(pageSize)
				.setParameter("vaccineId", vaccineId)
				.getResultList();
	}
	
	
	public List<Pet> getVaccinatedPetsByVaccineName(String vaccineName, int page, int pageSize){
		if (page < 0) {
			throw new IllegalArgumentException("The page can't be negative");
		}
		if (pageSize <= 0) {
			throw new IllegalArgumentException("The page size can't be negative or zero");
		}
		return em.createQuery("SELECT v.pet FROM Vaccination v\r\n"
				+ "WHERE v.vaccine.name = :vaccineName", Pet.class)
				.setFirstResult(page * pageSize)
				.setMaxResults(pageSize)
				.setParameter("vaccineName", vaccineName)
				.getResultList();
	}
	
	
}
