package es.uvigo.esei.xcs.rest;

import static java.util.Objects.requireNonNull;

import java.net.URI;
import javax.ejb.EJB;
import javax.ws.rs.*;
import javax.ws.rs.core.*;

import es.uvigo.esei.xcs.domain.entities.Vaccine;
import es.uvigo.esei.xcs.rest.entity.VaccineCreationData;
import es.uvigo.esei.xcs.rest.entity.VaccineEditionData;
import es.uvigo.esei.xcs.service.VaccineService;

@Path("vaccine")
@Consumes(MediaType.APPLICATION_JSON)
@Produces(MediaType.APPLICATION_JSON)
public class VaccineResource {

    @EJB
    private VaccineService vaccineService;

    @Context
    private UriInfo uriInfo;

    @GET
    public Response list(@QueryParam("page") @DefaultValue("0") int page,
                         @QueryParam("pageSize") @DefaultValue("10") int pageSize) {
        return Response.ok(vaccineService.list(page, pageSize)).build();
    }

    @POST
    public Response create(VaccineCreationData vaccineData) {
        requireNonNull(vaccineData, "vaccineData can't be null");
        //Vaccine vaccine = vaccineService.create(vaccineData.toVaccine());
        Vaccine vaccine = vaccineService.create(
        	vaccineData.getName(),
        	vaccineData.getType(),
        	vaccineData.getDoses(),
        	vaccineData.getPeriodicType(),
        	vaccineData.getPeriode()
        );
        URI uri = uriInfo.getAbsolutePathBuilder().path(String.valueOf(vaccine.getId())).build();
        return Response.created(uri).build();
    }

    @PUT
    @Path("{id}")
    public Response update(@PathParam("id") Long id, VaccineEditionData vaccineData) {
        requireNonNull(vaccineData, "vaccineData can't be null");
        Vaccine vaccine = vaccineService.get(id);
        vaccineData.assignData(vaccine);
        vaccineService.update(vaccine);
        return Response.ok().build();
    }

    @DELETE
    @Path("{id}")
    public Response delete(@PathParam("id") Long id) {
        vaccineService.remove(id);
        return Response.ok().build();
    }
}
