package es.uvigo.esei.xcs.service;

import javax.annotation.PostConstruct;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

@Singleton
public class CounterService {
	
	@PersistenceContext
	EntityManager em;
	
	private Long vaccineCounter;
	private Long petCounter;
	
	@PostConstruct
	public void init() {
		this.petCounter = em
				.createQuery("SELECT COUNT(p) FROM Pet p", Long.class)
				.getSingleResult();
		
		this.vaccineCounter = em
				.createQuery("SELECT COUNT(v) FROM Vaccine v", Long.class)
				.getSingleResult();
		
	}

	@Lock(LockType.WRITE)
	public void incrementPetCounter() {
		this.petCounter++;
	}
	
	@Lock(LockType.WRITE)
	public void incrementVaccineCounter() {
		this.vaccineCounter++;
	}
	
	@Lock(LockType.READ)
	public Long getPetCounter() {
		return this.petCounter;
	}
	
	@Lock(LockType.READ)
	public Long getVaccineCounter() {
		return this.vaccineCounter;
	}
	
	
}
