package es.uvigo.esei.xcs.jsf;

import javax.annotation.PostConstruct;
import javax.ejb.EJBException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;

import java.util.Date;
import java.text.SimpleDateFormat;
import java.io.Serializable;
import java.text.ParseException;
import java.util.List;
import java.util.Map;

import es.uvigo.esei.xcs.domain.entities.Pet;
import es.uvigo.esei.xcs.domain.entities.Vaccine;
import es.uvigo.esei.xcs.domain.entities.Vaccination;
import es.uvigo.esei.xcs.service.EmailService;
import es.uvigo.esei.xcs.service.PetService;
import es.uvigo.esei.xcs.service.VaccinationService;
import es.uvigo.esei.xcs.service.VaccineService;

@Named("petDetails")
@ViewScoped
public class PetDetailsManagedBean implements Serializable{
	private static final long serialVersionUID = 1L;

	@Inject
    private PetService petService;

    @Inject
    private VaccineService vaccineService;

    @Inject
    private VaccinationService vaccinationService;
    

    private Pet pet;

    private Long selectedVaccineId;
    private Date vaccinationDate;
    private List<Vaccine> allVaccines;

    @PostConstruct
    public void init() {
        Map<String, String> params = FacesContext.getCurrentInstance()
                .getExternalContext()
                .getRequestParameterMap();
        String id = params.get("id");
        if (id != null) {
            this.pet = petService.get(Long.parseLong(id));
        }
        this.allVaccines = vaccineService.list(0, 100);
    }

    public Pet getPet() {
        return pet;
    }

    public List<Vaccine> getAllVaccines() {
        return allVaccines;
    }

    public Long getSelectedVaccineId() {
        return selectedVaccineId;
    }

    public void setSelectedVaccineId(Long selectedVaccineId) {
        this.selectedVaccineId = selectedVaccineId;
    }

    public Date getVaccinationDate() {
        return vaccinationDate;
    }

    public void setVaccinationDate(Date vaccinationDate) {
        this.vaccinationDate = vaccinationDate;
    }

    public String vaccinate() {
        if (selectedVaccineId == null || vaccinationDate == null) {
            FacesContext.getCurrentInstance().addMessage(null,
                    new javax.faces.application.FacesMessage("Debe seleccionar vacuna y fecha"));
            return null;
        }
        
        try {
            Vaccination v = vaccinationService.create(pet.getId(), selectedVaccineId, vaccinationDate);
            this.pet = petService.get(pet.getId());
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage("Vacunación creada correctamente"));
        } catch (EJBException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IllegalArgumentException) {
                FacesContext.getCurrentInstance().addMessage(null,
                        new FacesMessage(cause.getMessage()));
            } else {
                FacesContext.getCurrentInstance().addMessage(null,
                        new FacesMessage("Error inesperado al crear vacunación"));
            }
        }
        return null;
    }
}
