package es.uvigo.esei.xcs.service;


import static java.util.Objects.requireNonNull;
import java.util.List;

import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import es.uvigo.esei.xcs.domain.entities.Administrator;
import es.uvigo.esei.xcs.domain.entities.User;

@Stateless
@RolesAllowed("ADMIN")
public class AdministratorService {
	@PersistenceContext
	EntityManager em;
	
	
	public Administrator get(int id) {
		return em.find(Administrator.class, id);
	}
	
	
	public List<User> list(int page, int pageSize){
		if (page < 0) {
			throw new IllegalArgumentException("The page can't be negative");
		}
		if (pageSize <= 0) {
			throw new IllegalArgumentException("The page size can't be negative or zero");
		}
		return em.createQuery("SELECT DISTINCT u FROM User u", User.class)
				.setFirstResult((page - 1) * pageSize)
				.setMaxResults(pageSize)
				.getResultList();
				
	}
	
	
	public Administrator create(Administrator administrator) {
		requireNonNull(Administrator.class, "Administrator can't be null");
		em.persist(administrator);
		
		return administrator;
	}
	
	
	public Administrator update(Administrator administrator) {
		requireNonNull(Administrator.class, "Administrator can't be null");
		return em.merge(administrator);
	}
	
	
	public void remove(int id) {
		em.remove(this.get(id));
	}
	
}
