package es.uvigo.esei.xcs.domain.entities;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;

@Entity
@DiscriminatorValue("PERIODIC")
public class PeriodicVaccine extends Vaccine implements Serializable {
	private static final long serialVersionUID = 1L;

	@Enumerated(EnumType.STRING)
	@Column(name = "periodicType", nullable = true, length = 6)
	private PeriodicType periodicType;
	
	@Column(name = "periode", nullable = true)
	private Integer periode;
	
	public PeriodicVaccine() {}	
	
	public PeriodicVaccine(String name, PeriodicType periodicType, Integer periode) {
		super(name);
		this.periodicType = periodicType;
		this.periode = periode;
	}
	
	public PeriodicType getPeriodicType() {
		return this.periodicType;
	}
	
	public void setPeriodicType(PeriodicType periodicType) {
		this.periodicType = periodicType;
	}
	
	public Integer getPeriode() {
		return this.periode;
	}
	
	public void setPeriode(Integer periode) {
		this.periode = periode;
	}

}
