package es.uvigo.esei.xcs.service;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import es.uvigo.esei.xcs.domain.entities.Identifier;
import static java.util.Objects.requireNonNull;

/**
 * EJB for managing Identifier entities.
 * Provides basic operations for creation and removal.
 * 
 * @author Breixo Senra
 */
@Stateless
public class IdentifierService {

    @PersistenceContext
    private EntityManager em;

    /**
     * Persists a new identifier.
     * 
     * @param identifier the Identifier entity to persist.
     * @return the persisted Identifier entity.
     * @throws NullPointerException if {@code identifier} is null.
     */
    public Identifier create(Identifier identifier) {
        requireNonNull(identifier, "Identifier can't be null");
        em.persist(identifier);
        return identifier;
    }

    /**
     * Removes an identifier by its value.
     * 
     * @param value the identifier value.
     */
    public void remove(String value) {
        Identifier identifier = em.find(Identifier.class, value);
        if (identifier != null) {
            em.remove(identifier);
        }
    }
}
