package es.uvigo.esei.xcs.jsf;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;

import java.util.Date;
import java.text.SimpleDateFormat;
import java.io.Serializable;
import java.text.ParseException;
import java.util.List;
import java.util.Map;

import es.uvigo.esei.xcs.domain.entities.Pet;
import es.uvigo.esei.xcs.domain.entities.Vaccine;
import es.uvigo.esei.xcs.domain.entities.Vaccination;
import es.uvigo.esei.xcs.service.PetService;
import es.uvigo.esei.xcs.service.VaccinationService;
import es.uvigo.esei.xcs.service.VaccineService;

@Named("petDetails")
//@RequestScoped
@ViewScoped
public class PetDetailsManagedBean implements Serializable{
	private static final long serialVersionUID = 1L;

	@Inject
    private PetService petService;

    @Inject
    private VaccineService vaccineService;

    @Inject
    private VaccinationService vaccinationService;

    private Pet pet;

    private Long selectedVaccineId;
    private Date vaccinationDate; // yyyy-MM-dd
    private List<Vaccine> allVaccines;

    @PostConstruct
    public void init() {
        Map<String, String> params = FacesContext.getCurrentInstance()
                .getExternalContext()
                .getRequestParameterMap();
        String id = params.get("id");
        if (id != null) {
            this.pet = petService.get(Long.parseLong(id));
        }
        this.allVaccines = vaccineService.list(0, 100); // ajustar paginación
    }

    public Pet getPet() {
        return pet;
    }

    public List<Vaccine> getAllVaccines() {
        return allVaccines;
    }

    public Long getSelectedVaccineId() {
        return selectedVaccineId;
    }

    public void setSelectedVaccineId(Long selectedVaccineId) {
        this.selectedVaccineId = selectedVaccineId;
    }

    public Date getVaccinationDate() {
        return vaccinationDate;
    }

    public void setVaccinationDate(Date vaccinationDate) {
        this.vaccinationDate = vaccinationDate;
    }

    // Método para vacunar
    public String vaccinate() {
        if (selectedVaccineId == null || vaccinationDate == null /*|| vaccinationDate.isEmpty()*/) {
            FacesContext.getCurrentInstance().addMessage(null,
                    new javax.faces.application.FacesMessage("Debe seleccionar vacuna y fecha"));
            return null;
        }

        try {
            //Date date = new SimpleDateFormat("yyyy-MM-dd").parse(vaccinationDate);
            Vaccination v = vaccinationService.create(pet.getId(), selectedVaccineId, vaccinationDate);
            // refrescar la mascota para mostrar la nueva vacunación
            this.pet = petService.get(pet.getId());
            FacesContext.getCurrentInstance().addMessage(null,
                    new javax.faces.application.FacesMessage("Vacunación creada correctamente"));
        } /*catch (ParseException e) {
            FacesContext.getCurrentInstance().addMessage(null,
                    new javax.faces.application.FacesMessage("Formato de fecha inválido"));
        }*/ catch (IllegalArgumentException e) {
            FacesContext.getCurrentInstance().addMessage(null,
                    new javax.faces.application.FacesMessage(e.getMessage()));
        }
        return null; // recargar la misma página
    }
}
